/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids.effects;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class WaterEffect
extends EffectFluid {
    public WaterEffect() {
        super("minecraft:water", (Fluid)Fluids.WATER, 1000);
    }

    @Override
    public void affectDrinker(FluidStack fluidStack, Level level, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Holder biome = level.getBiome(player.blockPosition());
            int duration = 140;
            if (player.isOnFire()) {
                player.clearFire();
            } else if (((Biome)biome.value()).getBaseTemperature() >= 2.0f) {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, duration, 0));
            }
        }
    }

    @Override
    public boolean canExecuteEffect(FluidStack stack, Level level, Entity entity) {
        return stack.getAmount() >= this.amountRequired;
    }
}

